org 100h   ; assume ds<=24c5 ah=0

  mov al,13h
  lds si,[si]  ; ds = 0x34c5 = texture, si = 0x13b0
  push 0xa000 - 160/16
  pop es       ; es = centered screen
  db 0xcd      ; int 0x10 | hlt

; compute one texture row
T db 0x10,0xf4 ; adc ah,dh
  adc ah,[si+127]
  shr ah,1
  mov [si],ah   ; T[a] = (rand(-16..15) + rand(0..2) + T[a+1] + T[a+127]) / 2
  rcr dx,cl
  sar dh,3
  dec si        ; si=time (goes down)
  loop T

X mov bh,-8      ; bh=z: -10..-128 or 9..127

Z:

  neg bh        ; bh = positive z
  js E

  mov ax,0xcccd
  mul di        ; dh=y, dl=x
  mov al,dh
  mul bh        ; ah=Y=y*z; y is always positive (need 200 rows)
  xchg ax,dx    ; dh=Y
  imul bh       ; ah=X=x*z, al=fraction of X
  mov bl,ah     ; bl=X
  not bh        ; bh++, bh = negative z
  cmp [bx+si],dh; hit if Y >= texture[X, -z-time]?
  jnb Z

;  mov ax,0xcccd
;  mul di        ; dh=y, dl=x
;  mov al,dl
;  imul bh       ; ah=X=x*z
;  mov bl,ah     ; bl=X
;  xchg ax,dx
;  mul bx        ; ah=Y=y*z; y is always positive
;  not bh        ; bh++, bh is negative z
;  cmp dh,[bx+si]; hit if Y >= texture[X, -z-time]?
;  jb Z

E:
;  shr al,5      ; no palette, dithered, white->black
;  add al,0x78
;  sub al,bh
;  shr al,3

;  imul ax,di,113; no palette, nicely dithered, white->black
;  shr al,5      
;  add al,0x78
;  sub al,bh
;  shr al,3

;  shr al,5       ; no palette, dithered, black->white
;  add al,bh
;  shr al,3

;  shr al,5      ; no palette, dithered, white->black
;  add al,0x78
;  add al,bh
;  shr al,3

;  shr al,5      ; no palette, dithered, black->white
;  add al,bh
;  shr al,3

; no palette, dithered, black->white
  aam 32        ; ah=al/32 (= 8 * fraction of X)
  add ah,bh
  shr ax,11

;  mov al,bh     ; no palette, undithered, black->white
;  shr al,3

  stosb
  loop X


  mov ch,2
  jmp T
